/*
 * Decompiled with CFR 0.152.
 */
package org.araqne.api;

import java.util.Date;

public class BundleStatus {
    private String symbolicName;
    private String version;
    private int state;
    private Date buildTimestamp;

    public BundleStatus(String symbolcName, String version, int state, Date lastModified) {
        this.symbolicName = symbolcName;
        this.version = version;
        this.state = state;
        this.buildTimestamp = lastModified;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public String getVersion() {
        return this.version;
    }

    public String getStateName() {
        return this.toStateName(this.state);
    }

    private String toStateName(int state) {
        switch (state) {
            case 32: {
                return "ACTIVE";
            }
            case 2: {
                return "INSTALLED";
            }
            case 4: {
                return "RESOLVED";
            }
            case 8: {
                return "STARTING";
            }
            case 16: {
                return "STOPPING";
            }
            case 1: {
                return "UNINSTALLED";
            }
        }
        throw new RuntimeException("not reachable");
    }

    public Date getBuildTimestamp() {
        return this.buildTimestamp;
    }

    public void setBuildTimestamp(Date l) {
        this.buildTimestamp = l;
    }

    public String toString() {
        return String.format("%s [%s]", this.symbolicName, this.toStateName(this.state));
    }
}

