/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import org.sikuli.basics.Debug;
import org.sikuli.basics.FileManager;
import org.sikuli.basics.Settings;
import org.sikuli.script.Image;
import org.sikuli.script.ImagePath;
import org.sikuli.script.RunTime;

@Deprecated
public class ImageLocator {
    static RunTime runTime = RunTime.get();
    static ArrayList<String> pathList = new ArrayList();
    static int firstEntries = 1;
    static File _cache_dir_global = new File(RunTime.get().fpBaseTempPath, "sikuli_cache/SIKULI_GLOBAL/");
    static Map<URI, String> _cache = new HashMap<URI, String>();

    @Deprecated
    public static String[] getImagePath() {
        return ImagePath.get();
    }

    @Deprecated
    public static String addImagePath(String path) {
        if (!ImagePath.add(path)) {
            return null;
        }
        return path;
    }

    @Deprecated
    public static void removeImagePath(String path) {
        ImagePath.remove(path);
    }

    @Deprecated
    public static void setBundlePath(String bundlePath) {
        ImagePath.setBundlePath(bundlePath);
    }

    @Deprecated
    public static String getBundlePath() {
        return ImagePath.getBundlePath();
    }

    public static String locate(String filename) throws IOException {
        if (filename != null) {
            String ret;
            URL url = ImageLocator.getURL(filename);
            if (url != null && (ret = ImageLocator.getFileFromURL(url)) != null) {
                return ret;
            }
            File f = new File(filename);
            if (f.isAbsolute()) {
                if (f.exists()) {
                    return f.getAbsolutePath();
                }
            } else {
                ret = ImageLocator.searchFile(filename);
                if (ret != null) {
                    return ret;
                }
            }
        } else {
            filename = "*** not known ***";
        }
        throw new FileNotFoundException("ImageLocator.locate: " + filename + " does not exist or cannot be found on ImagePath");
    }

    @Deprecated
    public static BufferedImage getImage(String filename) {
        return Image.create(filename).get();
    }

    private static String[] splitImagePath(String path) {
        if (path == null || "".equals(path)) {
            return new String[0];
        }
        path = path.replaceAll("[Hh][Tt][Tt][Pp]://", "__http__//");
        path = path.replaceAll("[Hh][Tt][Tt][Pp][Ss]://", "__https__//");
        String[] pl = path.split(Settings.getPathSeparator());
        for (int i = 0; i < pl.length; ++i) {
            boolean isURL = false;
            path = pl[i];
            if (path.indexOf("__http__") >= 0) {
                path = path.replaceAll("__http__//", "http://");
                isURL = true;
            } else if (path.indexOf("__https__") >= 0) {
                path = path.replaceAll("__https__//", "https://");
                isURL = true;
            }
            if (isURL) {
                if ((path = ImageLocator.getURL(path).getPath()) != null) {
                    if (path.endsWith("/")) continue;
                    pl[i] = path + "/";
                    continue;
                }
                pl[i] = null;
                continue;
            }
            File pathName = new File(path);
            if (pathName.exists()) {
                pl[i] = FileManager.slashify(pathName.getAbsolutePath(), true);
                continue;
            }
            pathList.remove(pl[i]);
            pl[i] = null;
        }
        return pl;
    }

    private static URL getURL(String s) {
        try {
            URL url = new URL(s);
            return url;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private static String addImagePath(String[] pl, boolean first) {
        int addedAt = firstEntries;
        if (addedAt == pathList.size()) {
            first = false;
        }
        for (int i = 0; i < pl.length; ++i) {
            String epl;
            if (pl[i] == null || pathList.contains(epl = pl[i])) continue;
            if (!first) {
                pathList.add(epl);
                continue;
            }
            pathList.add(addedAt, epl);
            ++addedAt;
        }
        if (pl.length > 0) {
            return pl[0];
        }
        return null;
    }

    private static String addImagePath(String path, boolean first) {
        String[] pl = ImageLocator.splitImagePath(path);
        ImageLocator.removeImagePath(pl);
        return ImageLocator.addImagePath(pl, first);
    }

    private static String addImagePathFirst(String path) {
        return ImageLocator.addImagePath(path, true);
    }

    private static String addImagePath(String[] pl) {
        return ImageLocator.addImagePath(pl, false);
    }

    private static String addImagePathFirst(String[] pl) {
        return ImageLocator.addImagePath(pl, true);
    }

    private static void removeImagePath(String[] pl) {
        for (int i = 0; i < pl.length; ++i) {
            if (pl[i] == null) continue;
            pathList.remove(pl[i]);
        }
    }

    private static void clearImagePath() {
        ListIterator<String> ip = pathList.listIterator(1);
        while (ip.hasNext()) {
            String p = (String)ip.next();
            if (p.substring(0, p.length() - 1).endsWith(".sikuli")) continue;
            ip.remove();
        }
        if (firstEntries == pathList.size()) {
            ImageLocator.addImagePath(System.getenv("SIKULI_IMAGE_PATH"));
            ImageLocator.addImagePath(System.getProperty("SIKULI_IMAGE_PATH"));
        } else {
            ImageLocator.addImagePathFirst(System.getProperty("SIKULI_IMAGE_PATH"));
            ImageLocator.addImagePathFirst(System.getenv("SIKULI_IMAGE_PATH"));
        }
    }

    private static void resetImagePath(String path) {
        ImageLocator.clearImagePath();
        String[] pl = ImageLocator.splitImagePath(path);
        if (pl.length > 0) {
            pathList.set(0, pl[0]);
            Settings.BundlePath = pl[0].substring(0, pl[0].length() - 1);
            pl[0] = null;
            ImageLocator.addImagePath(pl);
        }
    }

    private static void resetImagePath(String[] pl) {
        ImageLocator.clearImagePath();
        ImageLocator.addImagePath(pl);
    }

    private static String searchFile(String filename) {
        for (String path : pathList) {
            File f;
            URL url = ImageLocator.getURL(path);
            if (url != null) {
                try {
                    String ret = ImageLocator.getFileFromURL(new URL(url, filename));
                    if (ret != null) {
                        return ret;
                    }
                }
                catch (MalformedURLException ex) {
                    // empty catch block
                }
            }
            if (!(f = new File(path, filename)).exists()) continue;
            Debug.log(3, "ImageLocator: found " + filename + " in " + path, new Object[0]);
            return f.getAbsolutePath();
        }
        return null;
    }

    private static String getFileFromURL(URL url) {
        if (_cache_dir_global == null) {
            Debug.error("ImageLocator.getFileFromURL: Local cache dir not available - cannot download from url" + url, new Object[0]);
            return null;
        }
        try {
            URI uri = url.toURI();
            if (_cache.containsKey(uri)) {
                Debug.log(2, "ImageLocator.getFileFromURL: " + uri + " taken from cache", new Object[0]);
                return _cache.get(uri);
            }
            String localFile = FileManager.downloadURL(url, _cache_dir_global.getPath());
            if (localFile != null) {
                Debug.log(2, "ImageLocator.getFileFromURL: download " + uri + " to local: " + localFile, new Object[0]);
                _cache.put(uri, localFile);
            }
            return localFile;
        }
        catch (URISyntaxException e) {
            Debug.log(2, "ImageLocator.getFileFromURL: URI syntax error: " + url + ", " + e.getMessage(), new Object[0]);
            return null;
        }
    }

    static {
        pathList.add("");
        ImageLocator.resetImagePath("");
        if (pathList.size() >= 1 && "".equals(pathList.get(0))) {
            pathList.set(0, System.getProperty("user.dir"));
        }
        if (!_cache_dir_global.exists()) {
            try {
                _cache_dir_global.mkdir();
            }
            catch (Exception e) {
                Debug.error("ImageLocator: Local cache dir not possible: " + _cache_dir_global, new Object[0]);
                _cache_dir_global = null;
            }
        }
    }
}

