/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.guide;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import org.sikuli.guide.AnimationListener;
import org.sikuli.guide.Tracker;
import org.sikuli.guide.Visual;
import org.sikuli.script.Pattern;
import org.sikuli.script.Region;

public class SxAnchor
extends Visual {
    Region region;
    ArrayList<AnchorListener> listeners = new ArrayList();
    private boolean animateAnchoring = false;
    Pattern pattern = null;
    Tracker tracker = null;

    public SxAnchor() {
        this.setForeground(Color.black);
    }

    public SxAnchor(Pattern pattern) {
        this.pattern = pattern;
        this.setTracker(pattern);
    }

    public SxAnchor(Region region) {
        if (region != null) {
            this.region = region;
            this.setActualBounds(region.getRect());
        }
        this.setForeground(Color.black);
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public void setAnimateAnchoring(boolean animateAnchoring) {
        this.animateAnchoring = animateAnchoring;
    }

    public boolean isAnimateAnchoring() {
        return this.animateAnchoring;
    }

    public void addListener(AnchorListener listener) {
        this.listeners.add(listener);
    }

    public void found(Rectangle bounds) {
        for (AnchorListener listener : this.listeners) {
            listener.found(this);
        }
        if (this.isAnimateAnchoring()) {
            Point center = new Point();
            center.x = bounds.x + bounds.width / 2;
            center.y = bounds.y + bounds.height / 2;
            this.moveTo(center, new AnimationListener(){

                @Override
                public void animationCompleted() {
                    SxAnchor.this.anchored();
                }
            });
        } else {
            this.setActualLocation(bounds.x, bounds.y);
            this.anchored();
        }
    }

    public void anchored() {
        for (AnchorListener listener : this.listeners) {
            listener.anchored();
        }
        this.addFadeinAnimation();
        this.startAnimation();
    }

    public void setTracker(Pattern pattern) {
        this.setOpacity(0.0f);
        this.tracker = new Tracker(pattern);
        try {
            BufferedImage img = pattern.getBImage();
            this.setActualSize(img.getWidth(), img.getHeight());
            this.tracker.setAnchor(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startTracking() {
        if (this.tracker != null) {
            this.tracker.start();
        }
    }

    public void stopTracking() {
        if (this.tracker != null) {
            this.tracker.stopTracking();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
    }

    public static interface AnchorListener {
        public void anchored();

        public void found(SxAnchor var1);
    }
}

