/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.guide;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.sikuli.basics.Debug;
import org.sikuli.basics.Settings;
import org.sikuli.guide.ClickableWindow;
import org.sikuli.guide.GlobalMouseMotionTracker;
import org.sikuli.guide.SxAnchor;
import org.sikuli.guide.SxArrow;
import org.sikuli.guide.SxBeam;
import org.sikuli.guide.SxBracket;
import org.sikuli.guide.SxButton;
import org.sikuli.guide.SxCallout;
import org.sikuli.guide.SxCircle;
import org.sikuli.guide.SxClickable;
import org.sikuli.guide.SxFlag;
import org.sikuli.guide.SxImage;
import org.sikuli.guide.SxRectangle;
import org.sikuli.guide.SxSpotlight;
import org.sikuli.guide.SxText;
import org.sikuli.guide.TimeoutTransition;
import org.sikuli.guide.Tracker;
import org.sikuli.guide.Transition;
import org.sikuli.guide.TransitionDialog;
import org.sikuli.guide.Visual;
import org.sikuli.natives.SysUtil;
import org.sikuli.script.Location;
import org.sikuli.script.Pattern;
import org.sikuli.script.Region;
import org.sikuli.script.Screen;
import org.sikuli.util.EventObserver;
import org.sikuli.util.EventSubject;
import org.sikuli.util.OverlayTransparentWindow;

public class Guide
extends OverlayTransparentWindow
implements EventObserver {
    static float DEFAULT_TIMEOUT = 10.0f;
    public static final int FIRST = 0;
    public static final int MIDDLE = 1;
    public static final int LAST = 2;
    public static final int SIMPLE = 4;
    final float DIMMING_OPACITY = 0.5f;
    Robot robot;
    Region _region;
    JPanel content = null;
    Transition transition;
    ArrayList<Transition> transitions = new ArrayList();
    ArrayList<Tracker> trackers = new ArrayList();
    Transition triggeredTransition;
    ClickableWindow clickableWindow = null;
    SxBeam beam = null;

    public Guide() {
        super(new Color(0.1f, 0.0f, 0.0f, 0.1f), null);
        super.addObserver(this);
        this.init(new Screen());
    }

    public Guide(Region region) {
        super(new Color(0.1f, 0.0f, 0.0f, 0.1f), null);
        super.addObserver(this);
        this.init(region);
    }

    private void init(Region region) {
        try {
            this.robot = new Robot();
        }
        catch (AWTException e1) {
            e1.printStackTrace();
        }
        this.content = this.getJPanel();
        this._region = region;
        Rectangle rect = this._region.getRect();
        this.content.setPreferredSize(rect.getSize());
        this.add(this.content);
        this.setBounds(rect);
        this.getRootPane().putClientProperty("Window.shadow", Boolean.FALSE);
        ((JPanel)this.getContentPane()).setDoubleBuffered(true);
        this.setVisible(false);
        this.setFocusableWindowState(false);
    }

    public void focusBelow() {
        if (Settings.isMac()) {
            this.robot.keyPress(157);
            this.robot.keyPress(9);
            this.robot.keyRelease(157);
            this.robot.keyRelease(9);
            this.robot.delay(1000);
        }
    }

    @Override
    public void toFront() {
        if ((Settings.isMac() || Settings.isWindows()) && Settings.JavaVersion < 7) {
            SysUtil.getOSUtil().bringWindowToFront(this, true);
        }
        super.toFront();
    }

    @Override
    public void update(EventSubject es) {
    }

    public String showNow(float secs) {
        this.transitions.add(new TimeoutTransition((int)secs * 1000));
        return this.showNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String showNow() {
        Object token;
        String cmd = "Next";
        if (this.content.getComponentCount() == 0 && this.transitions.isEmpty()) {
            return cmd;
        }
        this.startTracking();
        this.setVisible(true);
        this.toFront();
        if (this.transitions.isEmpty()) {
            this.transitions.add(new TimeoutTransition((int)DEFAULT_TIMEOUT * 1000));
        }
        Object object = token = new Object();
        synchronized (object) {
            for (Transition transition : this.transitions) {
                transition.waitForTransition(new Transition.TransitionListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void transitionOccurred(Object source) {
                        Guide.this.triggeredTransition = (Transition)source;
                        Object object = token;
                        synchronized (object) {
                            token.notify();
                        }
                    }
                });
            }
            try {
                token.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (this.triggeredTransition instanceof ClickableWindow) {
            ClickableWindow cw = (ClickableWindow)this.triggeredTransition;
            cmd = cw.getLastClicked().getName();
        } else if (this.triggeredTransition instanceof TimeoutTransition) {
            cmd = "timeout";
        }
        this.reset();
        return cmd;
    }

    public void addToFront(JComponent comp) {
        this.addComponent(comp);
    }

    public void addComponent(JComponent comp) {
        this.content.add((Component)comp, 0);
    }

    public void addToFront(Visual comp) {
        this.addComponent(comp, 0);
    }

    public void addComponent(Visual comp, int index) {
        if (comp instanceof SxClickable) {
            this.content.add((Component)comp, 0);
            if (this.clickableWindow == null) {
                this.clickableWindow = new ClickableWindow(this);
                this.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosed(WindowEvent e) {
                        GlobalMouseMotionTracker.getInstance().stop();
                    }
                });
            }
            this.clickableWindow.addClickable((SxClickable)comp);
            this.addTransition(this.clickableWindow);
            return;
        }
        this.content.add((Component)comp, index);
        if (comp instanceof SxSpotlight) {
            this.setDarken(true);
        }
    }

    public void removeComponent(Component comp) {
        this.content.remove(comp);
    }

    private void reset() {
        this.clear();
        this.transitions.clear();
        if (this.clickableWindow != null) {
            this.clickableWindow.dispose();
            this.clickableWindow = null;
        }
        this.dispose();
    }

    public void clear() {
        if (this.clickableWindow != null) {
            this.clickableWindow.clear();
        }
        this.stopAnimation();
        this.stopTracking();
        this.content.removeAll();
        this.transition = null;
        this.beam = null;
        this.setDarken(false);
        this.setVisible(false);
        GlobalMouseMotionTracker.getInstance().stop();
    }

    public void setDefaultTimeout(float timeout_in_seconds) {
        DEFAULT_TIMEOUT = timeout_in_seconds;
    }

    public Region getRegion() {
        return this._region;
    }

    Point convertToRegionLocation(Point point_in_global_coordinate) {
        Point ret = new Point(point_in_global_coordinate);
        ret.translate(-this._region.x, -this._region.y);
        return ret;
    }

    boolean hasSpotlight() {
        for (Component comp : this.content.getComponents()) {
            if (!(comp instanceof SxSpotlight)) continue;
            return true;
        }
        return false;
    }

    public void updateSpotlights(ArrayList<Region> regions) {
        this.removeSpotlights();
        if (regions.isEmpty()) {
            this.setBackground(null);
            this.content.setBackground(null);
        } else {
            this.setBackground(new Color(0.0f, 0.0f, 0.0f, 0.5f));
            this.content.setBackground(new Color(0.0f, 0.0f, 0.0f, 0.5f));
            for (Region r : regions) {
                SxSpotlight spotlight = new SxSpotlight(r);
                spotlight.setShape(1);
            }
        }
        this.repaint();
    }

    public void removeSpotlights() {
        for (Component co : this.content.getComponents()) {
            if (!(co instanceof SxSpotlight)) continue;
            this.content.remove(co);
        }
    }

    public void setDarken(boolean darken) {
        if (darken) {
            this.content.setBackground(new Color(0.0f, 0.0f, 0.0f, 0.5f));
        } else {
            this.setBackground(null);
            this.content.setBackground(null);
        }
    }

    public Visual addBeam(Region r) {
        this.beam = new SxBeam(this, r);
        SxAnchor anchor = new SxAnchor(r);
        this.addTransition(this.beam);
        return anchor;
    }

    public void setDialog(String message) {
        TransitionDialog dialog = new TransitionDialog();
        dialog.setText(message);
        this.transition = dialog;
    }

    public void setDialog(TransitionDialog dialog_) {
        this.transition = dialog_;
    }

    public void stopAnimation() {
        for (Component co : this.content.getComponents()) {
            if (!(co instanceof Visual)) continue;
            ((Visual)co).stopAnimation();
        }
    }

    public void startAnimation() {
        for (Component co : this.content.getComponents()) {
            if (!(co instanceof Visual)) continue;
            ((Visual)co).startAnimation();
        }
    }

    public void addTransition(Transition t) {
        if (!this.transitions.contains(t)) {
            this.transitions.add(t);
        }
    }

    public Transition getTransition() {
        return this.transition;
    }

    public void startTracking() {
        for (Component co : this.content.getComponents()) {
            if (!(co instanceof SxAnchor)) continue;
            ((SxAnchor)co).startTracking();
        }
    }

    public void stopTracking() {
        for (Component co : this.content.getComponents()) {
            if (!(co instanceof SxAnchor)) continue;
            ((SxAnchor)co).stopTracking();
        }
    }

    public void addTracker(Pattern pattern, SxAnchor anchor) {
        Tracker tracker = null;
        tracker = new Tracker(this, pattern, null);
        this.trackers.add(tracker);
        try {
            BufferedImage img = pattern.getBImage();
            anchor.setActualSize(img.getWidth(), img.getHeight());
            tracker.setAnchor(anchor);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addTracker(Pattern pattern, Region r, Visual c) {
        Tracker tracker = null;
        for (Tracker t : this.trackers) {
            if (!t.isAlreadyTracking(pattern, r)) continue;
            tracker = t;
            break;
        }
        if (tracker == null) {
            tracker = new Tracker(this, pattern, r);
            this.trackers.add(tracker);
        }
        tracker.setAnchor(c);
    }

    public void addTracker(Pattern pattern, Region r, ArrayList<Visual> components) {
        Tracker tracker = new Tracker(this, pattern, r);
        for (Visual c : components) {
            tracker.setAnchor(c);
        }
        this.trackers.add(tracker);
    }

    public Visual rectangle() {
        SxRectangle gc = new SxRectangle();
        gc.setGuide(this);
        this.addToFront(gc);
        return gc;
    }

    public Visual circle() {
        SxCircle gc = new SxCircle();
        gc.setGuide(this);
        this.addToFront(gc);
        return gc;
    }

    public Visual text(String text) {
        SxText gc = new SxText(text);
        gc.setGuide(this);
        this.addToFront(gc);
        return gc;
    }

    public Visual flag(String text) {
        SxFlag gc = new SxFlag(text);
        gc.setGuide(this);
        this.addToFront(gc);
        return gc;
    }

    public Visual callout(String text) {
        SxCallout gc = new SxCallout(text);
        gc.setGuide(this);
        this.addToFront(gc);
        return gc;
    }

    public Visual image(Object img) {
        SxImage gc = null;
        if (img instanceof String) {
            gc = new SxImage((String)img);
        } else if (img instanceof BufferedImage) {
            gc = new SxImage((BufferedImage)img);
        }
        if (gc != null) {
            gc.setGuide(this);
            this.addToFront(gc);
        } else {
            Debug.log(2, "Guide.image: invalid argument", new Object[0]);
        }
        return gc;
    }

    public Visual bracket() {
        SxBracket gc = new SxBracket();
        gc.setGuide(this);
        this.addToFront(gc);
        return gc;
    }

    public Visual arrow(Object from, Object to) {
        SxArrow gc = null;
        if (from instanceof Region) {
            gc = new SxArrow(((Region)from).getCenter().getPoint(), ((Region)to).getCenter().getPoint());
        } else if (from instanceof Point || from instanceof Location) {
            gc = new SxArrow((Point)from, (Point)to);
        } else if (from instanceof Visual) {
            gc = new SxArrow((Visual)from, (Visual)to);
        }
        if (gc != null) {
            gc.setGuide(this);
            this.addToFront(gc);
        } else {
            Debug.log(2, "Guide.arrow: invalid arguments", new Object[0]);
        }
        return gc;
    }

    public Visual button(String name) {
        SxButton gc = new SxButton(name);
        gc.setGuide(this);
        this.addToFront(gc);
        return gc;
    }

    abstract class TrackerAdapter {
        TrackerAdapter() {
        }

        abstract void patternAnchored();
    }
}

