/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.guide;

import java.awt.Dimension;
import java.awt.Point;
import org.sikuli.guide.CenteredResizeToAnimator;
import org.sikuli.guide.CircleAnimator;
import org.sikuli.guide.NewAnimator;
import org.sikuli.guide.NewMoveAnimator;
import org.sikuli.guide.OpacityAnimator;
import org.sikuli.guide.ResizeAnimator;
import org.sikuli.guide.Visual;

public class AnimationFactory {
    static NewAnimator createResizeAnimation(Visual sklComponent, Dimension currentSize, Dimension targetSize) {
        return new ResizeAnimator(sklComponent, currentSize, targetSize);
    }

    static NewAnimator createCenteredResizeToAnimation(Visual sklComponent, Dimension targetSize) {
        return new CenteredResizeToAnimator(sklComponent, targetSize);
    }

    static NewAnimator createCenteredMoveAnimation(Visual sklComponent, Point source, Point destination) {
        NewMoveAnimator anim = new NewMoveAnimator(sklComponent, source, destination);
        anim.centered = true;
        return anim;
    }

    static NewAnimator createMoveAnimation(Visual sklComponent, Point source, Point destination) {
        return new NewMoveAnimator(sklComponent, source, destination);
    }

    public static NewAnimator createCircleAnimation(Visual sklComponent, Point origin, float radius) {
        return new CircleAnimator(sklComponent, origin, radius);
    }

    public static NewAnimator createOpacityAnimation(Visual sklComponent, float sourceOpacity, float targetOpacity) {
        return new OpacityAnimator(sklComponent, sourceOpacity, targetOpacity);
    }
}

