/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.basics;

import java.awt.event.KeyEvent;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.sikuli.basics.Debug;
import org.sikuli.basics.HotkeyListener;
import org.sikuli.basics.PreferencesUser;
import org.sikuli.basics.Settings;
import org.sikuli.script.Key;

public abstract class HotkeyManager {
    private static HotkeyManager _instance = null;
    private static Map<Integer, Integer> hotkeys;
    private static Map<Integer, Integer> hotkeysGlobal;
    private static final String HotkeyTypeCapture = "Capture";
    private static int HotkeyTypeCaptureKey;
    private static int HotkeyTypeCaptureMod;
    private static final String HotkeyTypeAbort = "Abort";
    private static int HotkeyTypeAbortKey;
    private static int HotkeyTypeAbortMod;

    public static HotkeyManager getInstance() {
        if (_instance == null) {
            String cls = HotkeyManager.getOSHotkeyManagerClass();
            if (cls != null) {
                try {
                    Class<?> c = Class.forName(cls);
                    Constructor<?> constr = c.getConstructor(new Class[0]);
                    _instance = (HotkeyManager)constr.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    Debug.error("HotkeyManager: Can't create " + cls + ": " + e.getMessage(), new Object[0]);
                }
            }
            hotkeys = new HashMap<Integer, Integer>();
        }
        return _instance;
    }

    public static void reset() {
        if (_instance == null || hotkeys.isEmpty()) {
            return;
        }
        Debug.log(3, "HotkeyManager: reset - removing all defined hotkeys.", new Object[0]);
        int[] hk = new int[hotkeys.size()];
        int i = 0;
        for (Integer k : hotkeys.keySet()) {
            boolean res = _instance._removeHotkey(k, hotkeys.get(k));
            if (!res) {
                Debug.error("HotkeyManager: reset: failed to remove hotkey: %s %s", HotkeyManager.getKeyModifierText(hotkeys.get(k)), HotkeyManager.getKeyCodeText(k));
                hk[i++] = -1;
                continue;
            }
            hk[i++] = k;
            Debug.log(3, "removed (%d, %d)", k, hotkeys.get(k));
        }
        for (int k : hk) {
            if (k == -1) continue;
            hotkeys.remove(k);
        }
    }

    private static String getOSHotkeyManagerClass() {
        String pkg = "org.sikuli.basics.";
        int theOS = Settings.getOS();
        switch (theOS) {
            case 1: {
                return pkg + "MacHotkeyManager";
            }
            case 0: {
                return pkg + "WindowsHotkeyManager";
            }
            case 2: {
                return pkg + "LinuxHotkeyManager";
            }
        }
        Debug.error("HotkeyManager: Hotkey registration is not supported on your OS.", new Object[0]);
        return null;
    }

    private static String getKeyCodeText(int key) {
        return KeyEvent.getKeyText(key).toUpperCase();
    }

    private static String getKeyModifierText(int modifiers) {
        String txtMod = KeyEvent.getKeyModifiersText(modifiers).toUpperCase();
        if (Settings.isMac()) {
            txtMod = txtMod.replace("META", "CMD");
            txtMod = txtMod.replace("WINDOWS", "CMD");
        } else {
            txtMod = txtMod.replace("META", "WIN");
            txtMod = txtMod.replace("WINDOWS", "WIN");
        }
        return txtMod;
    }

    public boolean addHotkey(String hotkeyType, HotkeyListener callback) {
        PreferencesUser pref = PreferencesUser.getInstance();
        if (hotkeyType == HotkeyTypeCapture) {
            HotkeyTypeCaptureKey = pref.getCaptureHotkey();
            HotkeyTypeCaptureMod = pref.getCaptureHotkeyModifiers();
            return this.installHotkey(HotkeyTypeCaptureKey, HotkeyTypeCaptureMod, callback, hotkeyType);
        }
        if (hotkeyType == HotkeyTypeAbort) {
            HotkeyTypeAbortKey = pref.getStopHotkey();
            HotkeyTypeAbortMod = pref.getStopHotkeyModifiers();
            return this.installHotkey(HotkeyTypeAbortKey, HotkeyTypeAbortMod, callback, hotkeyType);
        }
        Debug.error("HotkeyManager: addHotkey: HotkeyType %s not supported", hotkeyType);
        return false;
    }

    public String getHotKeyText(String hotkeyType) {
        PreferencesUser pref = PreferencesUser.getInstance();
        String key = "";
        String mod = "";
        if (hotkeyType == HotkeyTypeCapture) {
            key = HotkeyManager.getKeyCodeText(pref.getCaptureHotkey());
            mod = HotkeyManager.getKeyModifierText(pref.getCaptureHotkeyModifiers());
        } else if (hotkeyType == HotkeyTypeAbort) {
            key = HotkeyManager.getKeyCodeText(pref.getStopHotkey());
            mod = HotkeyManager.getKeyModifierText(pref.getStopHotkeyModifiers());
        } else {
            Debug.error("HotkeyManager: getHotKeyText: HotkeyType %s not supported", hotkeyType);
        }
        return mod + " " + key;
    }

    public boolean addHotkey(char key, int modifiers, HotkeyListener callback) {
        return this.addHotkey("" + key, modifiers, callback);
    }

    public boolean addHotkey(String key, int modifiers, HotkeyListener callback) {
        int[] keyCodes = Key.toJavaKeyCode(key.toLowerCase());
        int keyCode = keyCodes[0];
        return this.installHotkey(keyCode, modifiers, callback, "");
    }

    private boolean installHotkey(int key, int mod, HotkeyListener callback, String hotkeyType) {
        boolean res;
        String txtMod = HotkeyManager.getKeyModifierText(mod);
        String txtCode = HotkeyManager.getKeyCodeText(key);
        Debug.info("HotkeyManager: add %s Hotkey: %s %s (%d, %d)", hotkeyType, txtMod, txtCode, key, mod);
        boolean checkGlobal = true;
        for (Integer k : hotkeys.keySet()) {
            if (k != key || mod != hotkeys.get(key)) continue;
            res = _instance._removeHotkey(key, hotkeys.get(key));
            if (!res) {
                Debug.error("HotkeyManager: addHotkey: failed to remove already defined hotkey", new Object[0]);
                return false;
            }
            checkGlobal = false;
        }
        if (checkGlobal) {
            for (Integer kg : hotkeysGlobal.keySet()) {
                if (kg != key || mod != hotkeysGlobal.get(key)) continue;
                Debug.error("HotkeyManager: addHotkey: ignored: trying to redefine a global hotkey", new Object[0]);
                return false;
            }
        }
        if (res = _instance._addHotkey(key, mod, callback)) {
            if (hotkeyType.isEmpty()) {
                hotkeys.put(key, mod);
            } else {
                hotkeysGlobal.put(key, mod);
            }
        } else {
            Debug.error("HotkeyManager: addHotkey: failed", new Object[0]);
        }
        return res;
    }

    public boolean removeHotkey(String hotkeyType) {
        if (hotkeyType == HotkeyTypeCapture) {
            return this.uninstallHotkey(HotkeyTypeCaptureKey, HotkeyTypeCaptureMod, hotkeyType);
        }
        if (hotkeyType == HotkeyTypeAbort) {
            return this.uninstallHotkey(HotkeyTypeAbortKey, HotkeyTypeAbortMod, hotkeyType);
        }
        Debug.error("HotkeyManager: removeHotkey: using HotkeyType as %s not supported yet", hotkeyType);
        return false;
    }

    public boolean removeHotkey(char key, int modifiers) {
        return this.removeHotkey("" + key, modifiers);
    }

    public boolean removeHotkey(String key, int modifiers) {
        int[] keyCodes = Key.toJavaKeyCode(key.toLowerCase());
        int keyCode = keyCodes[0];
        return this.uninstallHotkey(keyCode, modifiers, "");
    }

    private boolean uninstallHotkey(int key, int mod, String hotkeyType) {
        String txtMod = HotkeyManager.getKeyModifierText(mod);
        String txtCode = HotkeyManager.getKeyCodeText(key);
        Debug.info("HotkeyManager: remove %s Hotkey: %s %s (%d, %d)", hotkeyType, txtMod, txtCode, key, mod);
        boolean res = _instance._removeHotkey(key, mod);
        if (res) {
            hotkeys.remove(key);
        } else {
            Debug.error("HotkeyManager: removeHotkey: failed", new Object[0]);
        }
        return res;
    }

    public abstract boolean _addHotkey(int var1, int var2, HotkeyListener var3);

    public abstract boolean _removeHotkey(int var1, int var2);

    public abstract void cleanUp();

    static {
        hotkeysGlobal = new HashMap<Integer, Integer>();
    }
}

