/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.javalib.util;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;

public class StdStreamRedirecter {
    private static final String LOG_ENCODING = "utf-8";
    final PrintStream stdOut = System.out;
    final PrintStream stdErr = System.err;
    private ByteArrayOutputStream redirectedSystemOut = new ByteArrayOutputStream();
    private ByteArrayOutputStream redirectedSystemErr = new ByteArrayOutputStream();

    public String getStdErrAsString() {
        return this.byteStreamToString(this.redirectedSystemErr);
    }

    public String getStdOutAsString() {
        return this.byteStreamToString(this.redirectedSystemOut);
    }

    public void redirectStdStreams() {
        try {
            System.setOut(new PrintStream((OutputStream)this.redirectedSystemOut, false, LOG_ENCODING));
            System.setErr(new PrintStream((OutputStream)this.redirectedSystemErr, false, LOG_ENCODING));
        }
        catch (UnsupportedEncodingException e) {
            new RuntimeException(e);
        }
    }

    public void resetStdStreams() {
        System.setOut(this.stdOut);
        System.setErr(this.stdErr);
    }

    private String byteStreamToString(ByteArrayOutputStream byteStream) {
        String retVal = null;
        try {
            retVal = byteStream.toString(LOG_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            new RuntimeException(e);
        }
        byteStream.reset();
        return retVal;
    }
}

