/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.javalib.keyword;

import java.util.Map;
import org.robotframework.javalib.org.apache.commons.collections.functors.NotNullPredicate;
import org.robotframework.javalib.org.apache.commons.collections.map.PredicatedMap;

public class KeywordMap {
    private Map map = PredicatedMap.decorate(this.map, NotNullPredicate.INSTANCE, NotNullPredicate.INSTANCE);

    public void add(String keywordName, Object value) {
        this.map.put(KeywordMap.normalizeKeywordName(keywordName), value);
    }

    public Object get(String keywordName) {
        return this.map.get(KeywordMap.normalizeKeywordName(keywordName));
    }

    public static String normalizeKeywordName(String keywordName) {
        if (keywordName == null) {
            return null;
        }
        keywordName = keywordName.toLowerCase().trim();
        keywordName = keywordName.replaceAll(" ", "");
        keywordName = keywordName.replaceAll("_", "");
        keywordName = keywordName.replaceAll("\t", "");
        keywordName = keywordName.replaceAll("\r", "");
        keywordName = keywordName.replaceAll("\n", "");
        return keywordName;
    }

    public int size() {
        return this.map.size();
    }

    public String[] getKeywordNames() {
        return this.map.keySet().toArray(new String[0]);
    }

    public boolean containsKeyword(String keywordName) {
        return this.map.containsKey(KeywordMap.normalizeKeywordName(keywordName));
    }

    protected Map getUnderlyingMap() {
        return this.map;
    }
}

