/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.javalib.beans.annotation;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.robotframework.javalib.beans.annotation.IBeanLoader;
import org.robotframework.javalib.beans.common.IClassFilter;
import org.robotframework.javalib.util.AntPathMatcher;
import org.robotframework.javalib.util.KeywordNameNormalizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeywordBeanLoader
implements IBeanLoader {
    protected final String keywordPattern;
    private final ClassLoader loader;
    private final AntPathMatcher pathMatcher = new AntPathMatcher();

    public KeywordBeanLoader(String keywordPattern, ClassLoader loader) {
        this.keywordPattern = keywordPattern;
        this.loader = loader;
    }

    @Override
    public Map loadBeanDefinitions(IClassFilter classFilter) {
        HashMap kws = new HashMap();
        Enumeration<URL> entries = this.getRootResources();
        while (entries.hasMoreElements()) {
            try {
                this.addURLKeywords(classFilter, kws, entries.nextElement());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return kws;
    }

    private void addURLKeywords(IClassFilter classFilter, Map kws, URL url) throws IOException {
        if (url.getProtocol().startsWith("jar")) {
            this.addJarKeywords(classFilter, kws, url);
        } else if (url.getProtocol().startsWith("file")) {
            this.addFileKeywords(classFilter, kws, url);
        } else {
            throw new RuntimeException("Unsupported URL type " + url);
        }
    }

    private void addFileKeywords(IClassFilter classFilter, Map kws, URL url) throws IOException {
        File urlFile = new File(URLDecoder.decode(url.getFile(), "UTF-8"));
        if (urlFile.isDirectory()) {
            for (String f : this.getChildrenFrom(this.pathMatcher.getRoot(this.keywordPattern), urlFile)) {
                this.addKeyword(classFilter, kws, f);
            }
        }
    }

    private void addJarKeywords(IClassFilter classFilter, Map kws, URL url) throws IOException {
        JarEntry entry;
        JarURLConnection connection = (JarURLConnection)url.openConnection();
        File jar = new File(URLDecoder.decode(connection.getJarFileURL().getFile(), "UTF-8"));
        JarInputStream is = new JarInputStream(new FileInputStream(jar));
        while ((entry = is.getNextJarEntry()) != null) {
            if (!entry.getName().endsWith(".class")) continue;
            this.addKeyword(classFilter, kws, entry.getName());
        }
    }

    private Enumeration<URL> getRootResources() {
        String root = this.pathMatcher.getRoot(this.keywordPattern);
        try {
            return this.loader.getResources(root);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private ArrayList<String> getChildrenFrom(String root, File file) {
        ArrayList<String> classes = new ArrayList<String>();
        for (File f : file.listFiles()) {
            if (f.isFile()) {
                if (!f.getName().endsWith(".class")) continue;
                classes.add(root + f.getName());
                continue;
            }
            classes.addAll(this.getChildrenFrom(root + f.getName() + "/", f));
        }
        return classes;
    }

    private void addKeyword(IClassFilter classFilter, Map<String, Object> kws, String className) throws IOException {
        if (className.indexOf("$") != -1) {
            return;
        }
        if (className.startsWith("java/") || className.startsWith("javax/")) {
            return;
        }
        if (!this.pathMatcher.match(this.keywordPattern, className)) {
            return;
        }
        String name = className.substring(0, className.length() - 6);
        Class cls = this.loadClass(name);
        if (classFilter.accept(cls)) {
            this.putInstance(kws, name, cls);
        }
    }

    private void putInstance(Map<String, Object> kws, String name, Class cls) {
        try {
            kws.put(new KeywordNameNormalizer().normalize(name), cls.newInstance());
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private Class loadClass(String name) {
        try {
            return this.loader.loadClass(name.replace("/", "."));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

