/*
 * Decompiled with CFR 0.152.
 */
package com.github.rainmanwy.robotframework.sikulilib.keywords;

import com.github.rainmanwy.robotframework.sikulilib.exceptions.ScreenOperationException;
import com.github.rainmanwy.robotframework.sikulilib.exceptions.TimeoutException;
import com.github.rainmanwy.robotframework.sikulilib.utils.CaptureFolder;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.robotframework.javalib.annotation.ArgumentNames;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywordOverload;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.sikuli.script.FindFailed;
import org.sikuli.script.ImagePath;
import org.sikuli.script.Match;
import org.sikuli.script.Region;
import org.sikuli.script.Screen;
import org.sikuli.script.ScreenImage;

@RobotKeywords
public class ScreenKeywords {
    private static double DEFAULT_TIMEOUT = 5.0;
    private final Screen screen = new Screen();
    private double timeout;
    private Map<String, Match> highlightMap = new HashMap<String, Match>();

    public ScreenKeywords() {
        this.timeout = DEFAULT_TIMEOUT;
    }

    private Match wait(String image, String timeout) throws TimeoutException {
        try {
            Match match = this.screen.wait(image, Double.parseDouble(timeout));
            this.capture(match);
            return match;
        }
        catch (FindFailed e) {
            this.capture();
            throw new TimeoutException("Timeout happend, could not find " + image, e);
        }
    }

    private Match find(String image) {
        try {
            Match match = this.screen.find(image);
            this.capture(match);
            return match;
        }
        catch (FindFailed e) {
            System.out.println("Could not find " + image);
            return null;
        }
    }

    private void capture() {
        ScreenImage image = this.screen.capture();
        String imagePath = image.save(CaptureFolder.getInstance().getCaptureFolder());
        System.out.println("*DEBUG* Saved path: " + imagePath);
        File file = new File(imagePath);
        String fileName = file.getName();
        System.out.println("*HTML* <img src='" + CaptureFolder.getInstance().getSubFolder() + "/" + fileName + "'/>");
    }

    private void capture(Region region) {
        ScreenImage image = this.screen.capture(region);
        String imagePath = image.save(CaptureFolder.getInstance().getCaptureFolder());
        System.out.println("*DEBUG* Saved path: " + imagePath);
        File file = new File(imagePath);
        String fileName = file.getName();
        System.out.println("*HTML* <img src='" + CaptureFolder.getInstance().getSubFolder() + "/" + fileName + "'/>");
    }

    @RobotKeyword(value="\u622a\u53d6\u6574\u4e2a\u5c4f\u5e55")
    @ArgumentNames(value={})
    public void desktopCaptureScreen() {
        this.capture();
    }

    @RobotKeyword(value="\u8bbe\u7f6esikuli\u5931\u6548\u65f6\u95f4\uff08\u5355\u4f4d\uff1as\uff09")
    @ArgumentNames(value={"timeout"})
    public String desktopSetTimeout(String timeout) {
        double oldTimeout = this.timeout;
        this.timeout = Double.parseDouble(timeout);
        return Double.toString(oldTimeout);
    }

    @RobotKeyword(value="\u8bbe\u7f6e\u4f7f\u7528\u56fe\u7247\u8def\u5f84")
    @ArgumentNames(value={"path"})
    public boolean desktopSetImagePath(String path) {
        return ImagePath.add(path);
    }

    @RobotKeyword(value="\u8bbe\u7f6e\u622a\u56fe\u4fdd\u5b58\u8def\u5f84")
    @ArgumentNames(value={"path"})
    public void desktopSetCaptureFolder(String path) {
        CaptureFolder.getInstance().setCaptureFolder(path);
    }

    @RobotKeyword(value="\u5355\u51fb\u56fe\u7247\uff0c\u4ec5\u6709\u4e00\u5f20\u56fe\u7247\u65f6\uff0c\u70b9\u51fb\u8be5\u56fe\u7247\uff1b\u6709\u4e24\u5f20\u56fe\u7247\u65f6\uff0c\u4ece\u7b2c\u4e8c\u5f20\u56fe\u7247\u533a\u57df\u5bfb\u627e\u7b2c\u4e00\u5f20\u6307\u5b9a\u56fe\u7247\uff0c\u7b2c\u4e8c\u5f20\u56fe\u7247\u53ef\u4e3a\u7a7a")
    @ArgumentNames(value={"targetImage", "areaImage="})
    public void desktopClick(String targetImage, String areaImage) throws Exception {
        Match match = this.wait(areaImage, Double.toString(this.timeout));
        System.out.println(areaImage + " is found!");
        match.click(targetImage);
        this.capture(match.find(targetImage));
    }

    @RobotKeywordOverload
    public void desktopClick(String targetImage) throws Exception {
        this.wait(targetImage, Double.toString(this.timeout));
        try {
            this.screen.click(targetImage);
        }
        catch (FindFailed e) {
            this.capture();
            throw new ScreenOperationException("Click " + targetImage + " failed" + e.getMessage(), e);
        }
    }

    @RobotKeyword(value="\u53cc\u51fb\u56fe\u7247\uff0c\u4ec5\u6709\u4e00\u5f20\u56fe\u7247\u65f6\uff0c\u70b9\u51fb\u8be5\u56fe\u7247\uff1b\u6709\u4e24\u5f20\u56fe\u7247\u65f6\uff0c\u4ece\u7b2c\u4e8c\u5f20\u56fe\u7247\u533a\u57df\u5bfb\u627e\u7b2c\u4e00\u5f20\u6307\u5b9a\u56fe\u7247\uff0c\u7b2c\u4e8c\u5f20\u56fe\u7247\u53ef\u4e3a\u7a7a")
    @ArgumentNames(value={"targetImage", "areaImage="})
    public void desktopDoubleClick(String targetImage, String areaImage) throws Exception {
        Match match = this.wait(areaImage, Double.toString(this.timeout));
        System.out.println(areaImage + " is found!");
        match.doubleClick(targetImage);
        this.capture(match.find(targetImage));
    }

    @RobotKeywordOverload
    public void desktopDoubleClick(String targetImage) throws Exception {
        this.wait(targetImage, Double.toString(this.timeout));
        try {
            this.screen.doubleClick(targetImage);
        }
        catch (FindFailed e) {
            this.capture();
            throw new ScreenOperationException("Double click " + targetImage + " failed" + e.getMessage(), e);
        }
    }

    @RobotKeyword(value="\u9f20\u6807\u53f3\u952e\u70b9\u51fb\u56fe\u7247,\u4ec5\u6709\u4e00\u5f20\u56fe\u7247\u65f6\uff0c\u70b9\u51fb\u8be5\u56fe\u7247\uff1b\u6709\u4e24\u5f20\u56fe\u7247\u65f6\uff0c\u4ece\u7b2c\u4e8c\u5f20\u56fe\u7247\u533a\u57df\u5bfb\u627e\u7b2c\u4e00\u5f20\u6307\u5b9a\u56fe\u7247\uff0c\u7b2c\u4e8c\u5f20\u56fe\u7247\u53ef\u4e3a\u7a7a")
    @ArgumentNames(value={"targetImage", "areaImage="})
    public void desktopRightClick(String targetImage, String areaImage) throws Exception {
        Match match = this.wait(areaImage, Double.toString(this.timeout));
        System.out.println(areaImage + " is found!");
        match.rightClick(targetImage);
        this.capture(match.find(targetImage));
    }

    @RobotKeywordOverload
    public void desktopRightClick(String targetImage) throws Exception {
        this.wait(targetImage, Double.toString(this.timeout));
        try {
            this.screen.rightClick(targetImage);
        }
        catch (FindFailed e) {
            this.capture();
            throw new ScreenOperationException("Right click " + targetImage + " failed" + e.getMessage(), e);
        }
    }

    @RobotKeyword(value="\u7b49\u5f85\u5f53\u524d\u5c4f\u5e55\u51fa\u73b0\u6307\u5b9a\u56fe\u7247")
    @ArgumentNames(value={"image", "timeout"})
    public void desktopWaitUntilScreenContain(String image, String timeout) throws TimeoutException {
        this.wait(image, timeout);
    }

    @RobotKeyword(value="\u5f53\u524d\u5c4f\u5e55\u5e94\u5305\u542b\u6307\u5b9a\u56fe\u7247")
    @ArgumentNames(value={"image"})
    public void desktopScreenShouldContain(String image) throws ScreenOperationException {
        Match match = this.find(image);
        if (match == null) {
            throw new ScreenOperationException("Screen should contain " + image);
        }
    }

    @RobotKeyword(value="\u5f53\u524d\u5c4f\u5e55\u4e0d\u5e94\u5305\u542b\u6307\u5b9a\u56fe\u7247")
    @ArgumentNames(value={"image"})
    public void desktopScreenShouldNotContain(String image) throws ScreenOperationException {
        Match match = this.find(image);
        if (match != null) {
            throw new ScreenOperationException("Screen should not contain " + image);
        }
    }

    @RobotKeyword(value="\u8f93\u5165\u6587\u672c\uff0c\u56fe\u7247\u53ef\u4ee5\u4e3a\u7a7a\uff0c\u4e0d\u652f\u6301\u4e2d\u6587\u8f93\u5165")
    @ArgumentNames(value={"text", "image="})
    public void desktopInputText(String text, String image) throws Exception {
        System.out.println("Input Text:");
        System.out.println(text);
        this.desktopClick(image);
        int result = this.screen.type(text);
        if (result == 0) {
            throw new ScreenOperationException("Input text failed");
        }
    }

    @RobotKeywordOverload
    public void desktopInputText(String text) throws Exception {
        System.out.println("Input Text:");
        System.out.println(text);
        int result = this.screen.type(text);
        if (result == 0) {
            throw new ScreenOperationException("Input text failed");
        }
    }

    @RobotKeyword(value="\u7c98\u8d34\u6587\u672c\uff0c\u56fe\u7247\u53ef\u4ee5\u4e3a\u7a7a\uff0c\u89e3\u51b3\u4e2d\u6587\u8f93\u5165\u95ee\u9898")
    @ArgumentNames(value={"text", "image="})
    public void desktopPasteText(String text, String image) throws Exception {
        System.out.println("Paste Text:");
        System.out.println(text);
        this.desktopClick(image);
        int result = this.screen.paste(text);
        if (result == 0) {
            throw new ScreenOperationException("Paste text failed");
        }
    }

    @RobotKeywordOverload
    public void desktopPasteText(String text) throws Exception {
        System.out.println("Paste Text:");
        System.out.println(text);
        int result = this.screen.paste(text);
        if (result == 0) {
            throw new ScreenOperationException("Paste text failed");
        }
    }
}

